//
//		Definition of the main game class
//
#ifndef THE_SPLASH_SCENE_H
#define THE_SPLASH_SCENE_H


#include "ldwScene.h"
#include "../World/WorldMap.h"
#include "ldwGameWindow.h"
#include "ldwImage.h"

class ldwButton;
class ldwSoundTrack;
class ldwSoundFx;
class theGameState;
class ldwTextControl;

class theSplashScene : public ldwScene
{
public:

	theSplashScene();
	~theSplashScene();

	void SetTimer();
	bool HandleKey(int messageId,int keyCode,int character);
	bool HandleMouse(int messageId,ldwPoint location);
	bool HandleMessage(int messageId,long data);
	void Activate(bool active);


protected:

	void DrawScene();
	void UpdateScene();

private:

	ldwUINT32 timer;
	ldwGameWindow *gameWindow;
	theGameState  *gs;

	int phase;

	bool visitedAtLeastOnce;
	bool m_bForceStaticSplash;

	enum {eMaxSplashes = 4};

	ldwImage     *splashBg[eMaxSplashes];

	int splashCount;

	ldwImage     *BG;
	ldwImageGrid *BG2;
	ldwImageGrid *BG3;
};
#endif